/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.theme;

import org.eclipse.swt.graphics.RGB;

public class RGBa {
    private int red;
    private int blue;
    private int green;
    private int alpha;

    public RGBa(RGB rgb) {
        this(rgb.red, rgb.green, rgb.blue);
    }

    public RGBa(int red, int green, int blue) {
        this(red, green, blue, 255);
    }

    public RGBa(int red, int green, int blue, int alpha) {
        this.red = red;
        this.blue = blue;
        this.green = green;
        this.alpha = alpha;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public RGB toRGB() {
        return new RGB(this.red, this.green, this.blue);
    }

    public String toString() {
        return "{" + this.red + ", " + this.green + ", " + this.blue + ", " + this.alpha + "}";
    }

    public boolean isFullyTransparent() {
        return this.alpha == 0;
    }

    public boolean isFullyOpaque() {
        return this.alpha == 255;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RGB) {
            RGB other = (RGB)obj;
            return this.isFullyOpaque() && other.red == this.red && other.green == this.green && other.blue == this.blue;
        }
        if (obj instanceof RGBa) {
            RGBa other = (RGBa)obj;
            return other.alpha == this.alpha && other.red == this.red && other.green == this.green && other.blue == this.blue;
        }
        return false;
    }

    public int hashCode() {
        return this.alpha << 32 | this.blue << 16 | this.green << 8 | this.red;
    }
}

